# fy5253Quarter {#fy5253quarter}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`fy5253Quarter(X, [weekday=0], [startingMonth=1], [qtrWithExtraWeek=1], [nearest=true], [offset], [n=1])`

## Arguments {#arguments}

**X** is a scalar/vector, its type can be DATE, DATETIME, TIMESTAMP, NANOTIMESTAMP.

**weekday** \(optional\) is an integer between 0 and 6. 0 means Monday, 1 means Tuesday, …, and 6 means Sunday. The default value is 0.

**startingMonth** \(optional\) is an integer between 1 and 12 indicating the beginning month of the year. The default value is 1.

**qtrWithExtraWeek** \(optional\) is an integer between 1 to 4. If there is a leap quarter \(usually the quarter contains 13 weeks, but the leap quarter contains 14 weeks \), it indicates the leap quarter.

**nearest** \(optional\) is a Boolean value with the default value of true.

**offset** \(optional\) is a scalar with the same data type as *X*. It must be smaller than the minimum value in *X*. The default value is the minimum value in *X*.

**n** \(optional\) is a positive integer. The default value is 1.

## Details {#details}

Using the 52-53 week in fiscal year \(4-4-5 calendar\), this function returns the start date of fiscal year which includes *X*.

-   If *nearest*=true, the last weekday which is closest to the last day of *startingMonth* will be used as the starting date of the fiscal year.

-   If *nearest*=false, the last weekday in *startingMonth* will be used as the starting date of the fiscal year.


If the *offset* is specified, indicating that starting from the *offset*, the result will be updated every *n* years. Note that only when *n* is greater than 1, the *offset* can take effect.

## Examples {#examples}

```
fy5253Quarter(2019.12.01,0,1,1,true);
// output: 2019.11.04

fy5253Quarter(2019.12.01,0,1,4,true);
// output: 2019.10.28   // The start date of the fiscal year 2019 is 2019.01.28. For the fiscal year 2020 it is 2020.02.03. The difference between them is 53 weeks, suggesting the existence of a leap quarter. qtrWithExtraWeek=1 means the first quarter is a leap quarter, which contains 14 weeks, so the start date of the quarter including 2019.12.01 is 2019.11.01; qtrWithExtraWeek=4 means that the fourth quarter is a leap season, which contains 14 weeks, so the start date of the quarter including 2019.12.01 is 2019.10.28.

date=2016.01.12 2016.02.25 2016.05.12 2016.06.28 2016.07.10 2016.08.18 2016.09.02 2016.10.16 2016.11.26 2016.12.30
time = [09:34:07,09:36:42,09:36:51,09:36:59,09:32:47,09:35:26,09:34:16,09:34:26,09:38:12,09:38:13]
sym = take(`MSFT,10)
price= 49.6 29.46 29.52 30.02 174.97 175.23 50.76 50.32 51.29 52.38
qty = 2200 1900 2100 3200 6800 5400 1300 2500 8800 4500
t1 = table(date, time, sym, qty, price);

select avg(price),sum(qty) from t1 group by fy5253Quarter(date,0,1,1,true,2016.01.01,2);
```

|fy5253Quarter\_date|avg\_price|sum\_qty|
|-------------------|----------|--------|
|2015.11.02|39.53|4100|
|2016.05.02|85.136667|21300|
|2016.10.31|51.835|13300|

Related function: [fy5253](fy5253.md)

