# flatten {#flatten}

## Syntax {#syntax}

`flatten(X)`

## Arguments {#arguments}

**X** is a vector, tuple or matrix.

## Details {#details}

Convert *X* into a 1D vector.

Note that for a tuple:

-   If it contains tuple elements, `flatten` converts these elements to 1D vectors and retains other elements, returns a tuple.

-   If it does not contain tuple elements, `flatten` returns a 1D vector.


## Examples {#examples}

Convert a matrix into a vector.

``` {#codeblock_dnn_vpk_zbc}
m=1..10$5:2;
flatten(m);
// output: [1,2,3,4,5,6,7,8,9,10]
```

Convert a list of vectors into a vector.

``` {#codeblock_fnn_vpk_zbc}
a=1..10;
b = a cut 2;
b;
// output: ([1,2],[3,4],[5,6],[7,8],[9,10])

flatten(b);
// output: [1,2,3,4,5,6,7,8,9,10]

x=flatten([1, [2,3]]);
x;
// output: [1,2,3]
```

Convert a tuple with tuple elements into a 1d vector, which involves several times of `flatten` operations:

``` {#codeblock_hnn_vpk_zbc}
list = (1, (2, (3, 4, 5)), (6, 7), 8, [9])
x1 = flatten(list)
x1
//(3, 4, 5) and (6, 7) are converted to 1D vectors
// output:(1,(2,[3,4,5]),[6,7],8,[9])

x2= flatten(x1)
x2
//(2,[3,4,5]) is converted to 1D vectors
// output:(1,[2,3,4,5],[6,7],8,[9])

x3= flatten(x2)
x3
// flatten to 1D vector
// output:[1,2,3,4,5,6,7,8,9]
```

Or use `flatten` with `reduce` to get the result after iteration:

``` {#codeblock_jnn_vpk_zbc}
reduce(flatten, init=list)
// output:[1,2,3,4,5,6,7,8,9]
```

