# fill! {#fill}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`fill!(obj, index, value)`

## Arguments {#arguments}

**obj** can be a vector, tuple, matrix, dictionary or table.

**index**

-   If *obj* is a vector, tuple or matrix, *index* is an integer scalar/vector;
-   If *obj* is a dictionary, *index* is a string scalar/vector indicating dictionary keys;
-   If *obj* is a table, *index* is a string scalar/vector indicating column names.

**value** is a scalar/vector.

## Details {#details}

Assign *value* to the elements of *obj* at *index*. It is equivalent to `obj[index]=value`.

## Examples {#examples}

Example 1. vector

``` {#codeblock_sxv_3zr_hzb}
a=[1,2,3,4];
fill!(a,3,12);
a;
// output: [1,2,3,12]

fill!(a,[0,1],[10,11]);
// output: [10,11,3,12]
```

Example 2. tuple

``` {#codeblock_kw4_lzr_hzb}
a=([1,2,3],["a","b","c"]);
fill!(a,0,[4,2]);
a[0];
[4,2]

// Create a tuple with 20 elements. Each element is a null value of floating type.
array(ANY, 20).fill!(0:20, float());
// which is equivalent to
t = array(ANY, 20);
t[0:20] = float()
```

Example 3. matrix

``` {#codeblock_u1b_lbs_hzb}
m=1..12$3:4;
fill!(m,2,5);
m;
```

|\#0|\#1|\#2|\#3|
|---|---|---|---|
|1|4|5|10|
|2|5|5|11|
|3|6|5|12|

``` {#codeblock_pvb_dcs_hzb}
fill!(m,[1,2],5);
m;
```

|\#0|\#1|\#2|\#3|
|---|---|---|---|
|1|5|5|10|
|2|5|5|11|
|3|5|5|12|

``` {#codeblock_kqc_2cs_hzb}
fill!(m,(1,),9);
m;
```

|\#0|\#1|\#2|\#3|
|---|---|---|---|
|1|5|5|10|
|9|9|9|9|
|3|5|5|12|

``` {#codeblock_obl_gcs_hzb}
m.fill!((1,2),10).fill!((2,2),12);
m;
```

|\#0|\#1|\#2|\#3|
|---|---|---|---|
|1|5|5|10|
|9|9|10|9|
|3|5|12|12|

Example 4. table

``` {#codeblock_x3d_3cs_hzb}
t=table(1 2 3 as id,10.2 45.2 12.3 as val);
fill!(t,`id,4 5 6);
t;
```

|id|val|
|---|---|
|4|10.2|
|5|45.2|
|6|12.3|

``` {#codeblock_shx_jcs_hzb}
fill!(t,`qty,452 142 48);
t;
```

|id|val|qty|
|:---|:---|:---|
|4|10.2|452|
|5|45.2|142|
|6|12.3|48|

Example 5. dictionary

``` {#codeblock_rx2_mcs_hzb}
d=dict(`a`b`c,1 2 3);
fill!(d,`a,4);
d;
/* output
c->3
a->4
b->2
*/
```



