# file {#file}

## Syntax {#syntax}

`file(name, [mode="r"], [isLittleEndian])`

## Arguments {#arguments}

**name** is a string indicating a file name.

**mode** is a string indicating the opening mode.

**isLittleEndian** \(optional\) is a Boolean value indicating if the file adopts the little endian format.

## Details {#details}

Open a file with a given mode. It must be executed by a logged-in user.

The opening mode could be one of the 6 modes: "r", "r+", "w", "w+", "a", and "a+".

-   "r" \(default\): Open text file for reading. The cursor is positioned at the beginning of the file.
-   "r+": Open for reading and writing. The cursor is positioned at the beginning of the file.
-   "w": Truncate file to zero length or create a text file for writing. The cursor is positioned at the beginning of the file.
-   "w+": Open for reading and writing. The file is created if it does not exist, otherwise it is truncated. The cursor is positioned at the beginning of the file.
-   "a": Open for writing. The file is created if it does not exist. The cursor is positioned at the end of the file. Subsequent writes to the file will always end up at the end of file.
-   "a+": Open for reading and writing. The file is created if it does not exist. The cursor is positioned at the end of the file. Subsequent writes to the file will always end up at the end of file.

Use the [close](../c/close.md) function to close an opened file handle.

## Examples {#examples}

```
fout=file("test.txt","w");
fout.writeLine("hello world!");
// output: 1
fout.close();

fin = file("test.txt");
print fin.readLine();
// output: hello world!
fin.close();
```

