# ffill {#ffill}

## Syntax {#syntax}

`ffill(obj, [limit])`

## Arguments {#arguments}

**obj** is a vector/matrix/table or an array vector.

**limit** \(optional\) is a positive integer that specifies the maximum number of consecutive null values to forward fill for each block of null values. *limit* is not supported when *obj* is an array vector.

## Details {#details}

If *obj* is a vector, forward fill the null values in *obj* with the previous non-null value.

If *obj* is an array vector:

-   For an empty row, fill it with the nearest non-empty row that precedes it.
-   For null values in a column, fill them with the nearest non-null value that precedes it within the same column.

If *obj* is a matrix or a table, forward fill the null values in each column of *obj* according to the above rules.

This operation creates a new vector and does not change the input vector. Function [ffill!](ffill!.md) changes the input vector.

**Note:** The only difference between `ffill` and `ffill!` is that the latter assigns the result to *obj* and thus changing the value of *obj* after the execution.

## Examples {#examples}

Example 1

```
x=1 2 3 NULL NULL NULL 4 5 6
x.ffill();
// output: [1,2,3,3,3,3,4,5,6]

x;
// The value of x is not changed.
// output: [1,2,3,,,,4,5,6]
```

Example 2: Specify parameter *limit*.

```
x=1 2 3 NULL NULL NULL 4 5 6
x.ffill(1);
// output: [1,2,3,3,,,4,5,6]
                
x.ffill(2);
x;
// output: [1,2,3,3,3,,4,5,6]
```

Example 3: Specify *obj* as a table.

```
date=[2012.06.12,2012.06.12,2012.06.13,2012.06.14,2012.06.15]
sym=["IBM","MSFT","IBM","MSFT","MSFT"]
price=[40.56,26.56,,,50.76]
qty=[2200,4500,,5600,]
timestamp=[09:34:07,09:35:26,09:36:42,09:36:51,09:36:59]
t=table(date,timestamp,sym,price,qty);
t;
```

|date|timestamp|sym|price|qty|
|----|---------|---|-----|---|
|2012.06.12|09:34:07|IBM|40.56|2200|
|2012.06.12|09:35:26|MSFT|26.56|4500|
|2012.06.13|09:36:42|IBM|||
|2012.06.14|09:36:51|MSFT||5600|
|2012.06.15|09:36:59|MSFT|50.76||

```
t.ffill();
```

|date|timestamp|sym|price|qty|
|----|---------|---|-----|---|
|2012.06.12|09:34:07|IBM|40.56|2200|
|2012.06.12|09:35:26|MSFT|26.56|4500|
|2012.06.13|09:36:42|IBM|26.56|4500|
|2012.06.14|09:36:51|MSFT|26.56|5600|
|2012.06.15|09:36:59|MSFT|50.76|5600|

```
select date, timestamp, sym, price.ffill() as price, qty.ffill() as qty from t context by sym;
```

|date|timestamp|sym|price|qty|
|----|---------|---|-----|---|
|2012.06.12|09:34:07|IBM|40.56|2200|
|2012.06.13|09:36:42|IBM|40.56|2200|
|2012.06.12|09:35:26|MSFT|26.56|4500|
|2012.06.14|09:36:51|MSFT|26.56|5600|
|2012.06.15|09:36:59|MSFT|50.76|5600|

Example 4: Specify *obj* as an array vector.

In the following example, the fourth row of the array vector x is empty, so it is filled with the third row \[6, 7, 8\]; the second element of the first column is null, so it is filled with the previous non-null value 1 in that column.

``` {#codeblock_gyx_4tb_d2c}
x = array(INT[], 0).append!([1 2 3, NULL 5, 6 7 8, NULL])
x
// output:[[1,2,3],[NULL,5],[6,7,8],[NULL]]
ffill(x)
// output:[[1,2,3],[1,5],[6,7,8],[6,7,8]]
```

