# ffill! {#ffill}

## Syntax {#syntax}

`ffill!(obj, [limit])`

## Arguments {#arguments}

**obj** is a vector/matrix/table.

**limit** is a positive integer that specifies the number of null values to forward fill for each block of null values.

## Details {#details}

If *obj* is a vector, forward fill the null values in *obj* with the previous non-null value.

If *obj* is a matrix or a table, forward fill the null values in each column of *obj* with the previous non-null value.

**Note:** The only difference between `ffill` and `ffill!` is that the latter assigns the result to *obj* and thus changing the value of *obj* after the execution.

## Examples {#id_xqb_35q_qzb}

Example 1

``` {#codeblock_hsb_35q_qzb}
x=1 2 3 NULL NULL NULL 4 5 6
x.ffill!(); 
x; 
// The value of x is changed. 
// output: [1,2,3,3,3,3,4,5,6]
```

Example 2: Specify parameter *limit* = 1. The first null value is filled.

``` {#codeblock_isb_35q_qzb}
x=1 2 3 NULL NULL NULL 4 5 6
x.ffill!(1);
// output: [1,2,3,3,,,4,5,6]
```

Example 3: Specify *obj* as a table.

``` {#codeblock_jsb_35q_qzb}
date=[2012.06.12,2012.06.12,2012.06.13,2012.06.14,2012.06.15]
sym=["IBM","MSFT","IBM","MSFT","MSFT"]
price=[40.56,26.56,,,50.76]
qty=[2200,4500,,5600,]
timestamp=[09:34:07,09:35:26,09:36:42,09:36:51,09:36:59]
t=table(date,timestamp,sym,price,qty);
ffill!(t); 
t;
```

|date|timestamp|sym|price|qty|
|----|---------|---|-----|---|
|2012.06.12|09:34:07|IBM|40.56|2200|
|2012.06.12|09:35:26|MSFT|26.56|4500|
|2012.06.13|09:36:42|IBM|26.56|4500|
|2012.06.14|09:36:51|MSFT|26.56|5600|
|2012.06.15|09:36:59|MSFT|50.76|5600|

