# extractMktData {#extractMktData}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`extractMktData(mktData)`

## Arguments {#arguments}

**mktData**is a MKTDATA scalar or a tuple of MKTDATA scalars.

## Details {#details}

Extract the data within the MKTDATA object\(s\).

**Return value:**

-   Returns a dictionary if the *mktData* is a scalar.

-   Returns a tuple of dictionaries if the *mktData* is a tuple.


## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
fxSpot = {
    "mktDataType": "Spot",
    "referenceDate": 2025.08.18,
    "version": 0, 
    "spotDate": 2025.08.20,
    "spotType": "FxSpot",
    "value": 7.2659,
    "unit": "USDCNY"
}
fxSpot = parseMktData(fxSpot)
print extractMktData(fxSpot)

/* output
fxSpot = {
    "mktDataType": "Spot",
··· 12 lines in total ···
mktDataType->Spot
spotType->FxSpot
spotDate->2025.08.20
referenceDate->2025.08.18
value->7.265900000000001
unit->USDCNY
version->0
underlying->USDCNY
*/
```

**Related function:** [parseMktData](../p/parseMktData.md)

