# existsTable {#existstable}

## Syntax {#syntax}

`existsTable(dbUrl, tableName)`

## Arguments {#arguments}

**dbUrl** is a string indicating the path of a database.

**tableName** is a string indicating a table name.

## Details {#details}

Check if the specified table exists in the specified database.

## Examples {#examples}

To check if a table exists in a DFS database \(on a data node or compute node\). The following scripts must be executed on a data node or compute node.

```
n=1000000
ID=rand(10, n)
dates=2017.08.07..2017.08.11
date=rand(dates, n)
x=rand(10.0, n)
t=table(ID, date, x)

db = database("dfs://valueDB", VALUE, 2017.08.07..2017.08.11)
pt = db.createPartitionedTable(t, `pt, `date);
pt.append!(t);

existsTable("dfs://valueDB", `pt);
// output: true

existsTable("dfs://valueDB/20170807", `pt);
// output: true
```

