# existsSubscriptionTopic {#existssubscriptiontopic}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`existsSubscriptionTopic([server], tableName, [actionName])`

Alias: existSubscriptionTopic

## Arguments {#arguments}

**server** \(optional\) is a string indicating the node alias of the subscribed stream table, or the handler of a remote call connection. If *server* is not specified or an empty string, it means the streaming data is from the local server.

**tableName** is a string indicating the name of a shared stream table.

**actionName** \(optional\) is a string indicating the name of the subscription task. *actionName* can only contain letters, numbers and underscores. If the *actionName* is specified when the subscription is created, it must also be specified here.

## Details {#details}

Check the existence of a subscription topic of a shared stream table. Return "true" if the subscription topic exists, "false" if it doesn't.

## Examples {#examples}

```
t=streamTable(1000000:0,`date`time`sym`qty`price`exch,[DATE,TIME,SYMBOL,INT,DOUBLE,SYMBOL])
share t as trades
trades_1=streamTable(1000000:0,`date`time`sym`qty`price`exch,[DATE,TIME,SYMBOL,INT,DOUBLE,SYMBOL])
subscribeTable(tableName=`trades, actionName=`vwap, offset=-1, handler=append!{trades_1})
existsSubscriptionTopic(,`trades,`vwap)
// output: true
```

