# existsDatabase {#existsdatabase}

## Syntax {#syntax}

`existsDatabase(dbUrl)`

## Arguments {#arguments}

**dbUrl** is a string indicating the path of a database folder.

## Details {#details}

Check if a database exists under the specified folder.

## Examples {#examples}

To check if a DFS database exists:

```
n=1000000
ID=rand(10, n)
dates=2017.08.07..2017.08.11
date=rand(dates, n)
x=rand(10.0, n)
t=table(ID, date, x)

db = database("dfs://valueDB", VALUE, 2017.08.07..2017.08.11)
pt = db.createPartitionedTable(t, `pt, `date);
pt.append!(t);

existsDatabase("dfs://valueDB");
// output: true

existsDatabase("dfs://valueDB/20170807");
// output: false
```

