# ewmStd {#ewmstd}

## Syntax {#syntax}

`ewmStd(X, [com], [span], [halfLife], [alpha], [minPeriods=0], [adjust=true], [ignoreNA=false], [bias=false])`

## Details {#details}

Calculate exponentially weighted moving standard deviation.

Exactly one of the parameters *com*, *span*, *halfLife* and *alpha* must be specified.

## Arguments {#arguments}

**X** is a numeric vector.

**com** \(optional\) is a non-negative floating number and specifies decay in terms of center of mass. alpha=1/\(1+com\) where alpha is the decay factor.

**span** \(optional\) is a positive floating number larger than 1 and specifies decay in terms of span. alpha=2/\(span+1\).

**halfLife** \(optional\) is a positive floating number and specifies decay in terms of half-life. alpha=1-exp\(log\(0.5\)/halfLife\).

**alpha** \(optional\) is a floating number between 0 and 1 and directly specifies decay.

**minPeriods** \(optional\) is an integer indicating the minimum number of observations in window required to have a value \(otherwise result is NULL\). The default value is 0.

**adjust** \(optional\) is a Boolean value. The default value is true.

-   If *adjust*=true, the weights are \(1-alpha\)^\(n-1\), \(1-alpha\)^\(n-2\), …, 1-alpha, 1 divided by their sum.

-   If *adjust*=false, the weights are \(1-alpha\)^\(n-1\), \(1-alpha\)^\(n-2\)\*alpha, \(1-alpha\)^\(n-3\)\*alpha^2,…, \(1-alpha\)\*alpha, alpha.


**ignoreNA** \(optional\) is a Boolean value indicating whether to ignore missing values. The defaut value is false.

**other** \(optional\) is a numeric vector of the same length as *X*.

**bias** \(optional\) is a Boolean value indicating whether the result is biased. The default value is false, meaning the bias is corrected.

## Examples {#examples}

```python
a=[0,1,2,int(),4]
ewmStd(X=a,com=0.5);
// output: [,0.707107,0.919866,0.919866,1.720513]

ewmStd(X=a,com=0.5,ignoreNA=true);
// output: [,0.707107,0.919866,0.919866,1.679057]

n = 20
colNames = `time`sym`qty`price
colTypes = [TIME,SYMBOL,INT,DOUBLE]
t1 = table(n:0, colNames, colTypes)
insert into t1 values(09:30:00.001,`AAPL,100,56.5)
insert into t1 values(09:30:00.001,`AAPL,200,30.5)
insert into t1 values(09:30:00.001,`DELL,150,35.5)
insert into t1 values(09:30:00.001,`DELL,170,60.5)
insert into t1 values(09:30:00.001,`DELL,130,40.5)
b=[2,4,3,6,5]
ewmStd(X=t1,com=0.5);
```

|time|sym|qty|price|
|----|---|---|-----|
|09:30:00.001|AAPL| | |
|09:30:00.001|AAPL|70.7107|18.3848|
|09:30:00.001|DELL|39.2232|9.2487|
|09:30:00.001|DELL|23.271|17.2418|
|09:30:00.001|DELL|27.466|12.6944|

