# ewmMean {#ewmmean}

## Syntax {#syntax}

`ewmMean(X, [com], [span], [halfLife], [alpha], [minPeriods=0], [adjust=true], [ignoreNA=false], [times])`

## Details {#details}

Calculate exponentially weighted moving average.

Exactly one of the parameters *com*, *span*, *halfLife* and *alpha* must be specified.

## Arguments {#arguments}

**X** is a numeric vector.

**com** \(optional\) is a non-negative floating number and specifies decay in terms of center of mass. alpha=1/\(1+com\) where alpha is the decay factor.

**span** \(optional\) is a positive floating number larger than 1 and specifies decay in terms of span. alpha=2/\(span+1\).

**halfLife** \(optional\) is a positive floating number or a scalar of DURATION type specifying the half-life. alpha=1-exp\(ln\(2\)/halfLife\). If *halfLife* is a DURATION, the *times* must be specified with the same time unit.

**alpha** \(optional\) is a floating number between 0 and 1 and directly specifies decay.

**minPeriods** \(optional\) is an integer indicating the minimum number of observations in window required to have a value \(otherwise result is NULL\). The default value is 0.

**adjust** \(optional\) is a Boolean value. The default value is true.

-   If *adjust*=true, the weights are \(1-alpha\)^\(n-1\), \(1-alpha\)^\(n-2\), …, 1-alpha, 1 divided by their sum.

-   If *adjust*=false, the weights are \(1-alpha\)^\(n-1\), \(1-alpha\)^\(n-2\)\*alpha, \(1-alpha\)^\(n-3\)\*alpha^2,…, \(1-alpha\)\*alpha, alpha.


**ignoreNA** \(optional\) is a Boolean value indicating whether to ignore null values when calculating weights. The default value is false.

Take \[x0, NULL, x2\] for example,

-   If *ignoreNA* = true,

    -   *adjust* = false, the weights of x0 and x2 are 1-α and α.

    -   *adjust* = true, the weights of x0 and x2 are 1-α and 1.

-   If *ignoreNA* = false,

    -   *adjust* = false, the weights of x0 and x2 are \(1-α\)2 and α.

    -   *adjust* = true, the weights of x0 and x2 are \(1-α\)2 and 1.


**times** \(optional\) is a strictly increasing vector of temporal type, with the same length as *X*. Required only when *halfLife* is a DURATION, and must have the same unit as *halfLife*.

Note: If *halfLife* uses B \(business day\) or a trading calendar unit, *times* must be a vector of DATE type.

## Examples {#examples}

```
a=[0,1,2,int(),4]
ewmMean(X=a,com=0.5);
// output: [0,0.75,1.615385,1.615385,3.670213]
        
ewmMean(X=a,com=0.5,ignoreNA=true);
// output: [0,0.75,1.615385,1.615385,3.225] 
       
ewmMean(a, halfLife = 4d, times=[2019.12.31, 2020.01.03, 2020.01.10, 2020.01.15, 2020.01.17])
// output: [0,0.627115,1.558466,1.558466,3.256043]  

// Specify halfLife using a trading calendar.
ewmMean(a, halfLife = 4XNYS, times=[2019.12.31, 2020.01.03, 2020.01.10, 2020.01.15, 2020.01.17])
// output: [0,0.585786,1.409080,1.409080,2.913483]
  
// Specify halfLife using a business day.
ewmMean(a, halfLife = 4B, times=[2019.12.31, 2020.01.03, 2020.01.10, 2020.01.15, 2020.01.17])
// output: [0,0.627115,1.448981,1.448981,2.947520] 

n = 20
colNames = `time`sym`qty`price
colTypes = [TIME,SYMBOL,INT,DOUBLE]
t1 = table(n:0, colNames, colTypes)
insert into t1 values(09:30:00.001,`AAPL,100,56.5)
insert into t1 values(09:30:00.001,`AAPL,200,30.5)
insert into t1 values(09:30:00.001,`DELL,150,35.5)
insert into t1 values(09:30:00.001,`DELL,170,60.5)
insert into t1 values(09:30:00.001,`DELL,130,40.5)
b=[2,4,3,6,5]
ewmMean(X=t1,com=0.5);
```

|time|sym|qty|price|
|----|---|---|-----|
|09:30:00.001|AAPL|100|56.5|
|09:30:00.001|AAPL|175|37|
|09:30:00.001|DELL|157.6923|35.9615|
|09:30:00.001|DELL|166|52.525|
|09:30:00.001|DELL|141.9008|44.4752|

