# euclidean {#euclidean}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`euclidean(X, Y)`

## Arguments {#arguments}

**X** and **Y** are numeric scalars, or vectors/matrices of the same size.

## Details {#details}

If *X* and *Y* are scalars or vectors, return the result of their Euclidean distance.

If *X* or *Y* is a matrix, return a vector that is the result of the Euclidean distance between elements in each column. Note that if both *X* and *Y* are indexed matrices or indexed series, return the results of rows with the same label. Rows with different labels will be ignored.

As with all other aggregate functions, null values are ignored in the calculation.

## Examples {#examples}

```
a=[100, 0, 0]
b=[0, 51, NULL]
euclidean(a,b)
// output: 112.254176

s1=indexedSeries(1 2 4, 10.4 11.2 9)
s2=indexedSeries(1 2 5, 23.5 31.2 26)
euclidean(s1,s2)
// output: 23.9084

m=matrix(23 56 47, 112 94 59)
euclidean(a,m)
// output: [106.1791,111.6288]

m1=matrix(11 15 89, 52 41 63)
euclidean(m,m1)
// output: [59.9083,80.1561]

m.rename!(2020.01.01..2020.01.03, `A`B)
m.setIndexedMatrix!()
m1.rename!(2020.01.01 2020.01.03 2020.01.04, `A`B)
m1.setIndexedMatrix!()
euclidean(m,m1)
// output: [34.176,62.6418]
```

Related function: [rowEuclidean](../r/rowEuclidean.md)

