# esd {#esd}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`esd(data, [hybrid], [maxAnomalies], [alpha])`

## Arguments {#arguments}

**data** is a numeric vector.

**hybrid** \(optional\) is a Boolean value indicating whether to use median and median absolute deviation to replace mean and standard deviation. The results are more robust if *hybrid*=true. The default value is false.

**maxAnomalies** \(optional\) is a positive integer or a floating-point number between 0 and 0.5. The default value is 0.1.

-   If *maxAnomalies* is a positive integer, it must be smaller than the size of data. It indicates the upper bound of the number of anomalies.

-   If *maxAnomalies* is a floating-point number between 0 and 0.5, the upper bound of the number of anomalies is `int(size(data) * maxAnomalies)`.


**alpha** \(optional\) is a positive number indicating the significance level of the statistical test. A larger *alpha* means a higher likelihood of detecting anomalies.

## Details {#details}

Conduct anomaly detection with the Extreme Studentized Deviate test \(ESD\).

**Return value**: a table with 2 columns where column index records the subscript of anomalies in data and column anoms are the anomaly values.

## Examples {#examples}

```
n = 1000
ts = rand(10.0, n)
ts[500 600 700 999] += 20
esd(ts);
```

|index|anoms|
|-----|-----|
|600|29.815742|
|700|25.517493|
|500|25.17515|
|999|24.748516|

