# eqPercent {#eqpercent_0}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`eqPercent(X, Y, [toleranceLevel=0.0001])`

## Arguments {#arguments}

-   **X** / **Y** are two numbers to compare. They must be scalars, vectors, pairs, or matrices of the same shape. Supported data types include BOOL, CHAR, SHORT, INT, LONG, FLOAT, DOUBLE, DECIMAL. Note: *X* and *Y* must be of the same form, and elements in *X* and *Y* can be of different data types.
-   **toleranceLevel** \(optional\) is a number in \(0, 100\), representing the tolerable percentage error. The default value is 0.0001. This means the absolute difference between the two elements must not exceed the *toleranceLevel*percentage of the absolute value of *Y*. For example, if *Y* is 1000 and *toleranceLevel*is 0.0001, the allowable error is 1000 \* 0.0001% = 0.001. Thus, an *X* value between \[999.999, 1000.001\] will be considered equal to *Y*.

## Details {#details}

Check element-wise equality of two inputs *X* and *Y* are equal within the specified *toleranceLevel*.

**Return Value**: A Boolean scalar

Note:

-   If the type of the input *X* or *Y* is not supported, the function returns the result of `eqObj(X, Y).`

-   Null values are not equal to other values.

-   Null values of different types are considered equal.


## Examples {#examples}

``` {#codeblock_zn2_sdj_zbc}
eqPercent((1.9999 2.9999), (2 3))
// Output: true

eqPercent((1.9 2.9), (2 3), 2)
// Output: false
```

Elements in *X* and *Y* can be of different data types:

``` {#codeblock_b42_sdj_zbc}
eqPercent((1.99f 2.99), (2 3h), 2)
// Output: true
```

When comparing null values:

``` {#codeblock_d42_sdj_zbc}
// Null values are not equal to other values
eqPercent((1.9999 NULL), (2 3))
// Output: false

// Null values of DOUBLE and VOID types are considered equal
a=double(NULL)
eqPercent(a,NULL)
// Output: true
```

When an unsupported type is passed, the function returns the result of `eqObj(X, Y)`:

``` {#codeblock_f42_sdj_zbc}
eqPercent(2012.06M, 2)
// Output: false
```

