# eqObj {#eqobj}

## Syntax {#syntax}

`eqObj(obj1, obj2, [precision])`

## Arguments {#arguments}

**obj1** / **obj2** is a scalar/pair/vector/matrix.

**precision** \(optional\) is a non-negative integer. FLOAT and DOUBLE types are compared up to precision digits after the decimal point.

## Details {#details}

Check if the data types and values of two objects are identical. Return true only if both data types and values are identical. Please note that `eqObj` returns false if values are identical but object types are different. This is different from fuction [eq](eq.md).

When comparing floating point numbers, function `eqObj` determines whether the values of *obj1* and *obj2* are equal based on the result of `abs(obj1-obj2)<=pow(10,-precision)`.

## Examples {#examples}

```
eqObj(2, 2.0);
// output: false

eq(2, 2.0);
// output: true

eqObj(1.1, 1.2, 0);
// output: true

eqObj(1.1, 1.2, 1);
// output: true

eqObj(1 2 3, 1 2 3);
// output: true

eq(1 2 3, 1 2 3);
// output: [true,true,true]
```

`eqObj` cannot be used to compare 2 tables directly. However, we can use the template function [each](../Templates/each.md) to compare the values of each column for 2 tables:

```
t1=table(1 2 3 as x, 4 5 6 as y);
t2=table(1 2 3 as x, 4 5 6 as y);

t1.values();
// output: ([1,2,3],[4,5,6])

each(eqObj, t1.values(), t2.values());
// output: [true,true]
```

