# eqFloat {#eqfloat}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`eqFloat(X, Y, [precision=9])`

## Arguments {#arguments}

**X** / **Y** is a numeric scalar/vector/matrix. If *X* or *Y* is a vector/matrix, the other is a scalar or a vector/matrix of the same size.

**precision** is a non-negative integer. FLOAT and DOUBLE types are compared up to precision digits after the decimal point.

## Details {#details}

Return the element-by-element comparison of *X* and *Y* with the given precision.

## Examples {#examples}

```
eqFloat(0.1234567891, 0.123456789);
// output: true

eqFloat(0.123456788, 0.123456789);
// output: false

eqFloat(0.123456788 0.123456789 0.1234567891, 0.123456789);
// output: [false,true,true]
```

