# ema {#ema}

## Syntax {#syntax}

`ema(X, window, warmup=false)`

Please see [TALib](../Themes/TALib.md) for the parameters and windowing logic.

## Arguments {#arguments}

**warmup** is a Boolean value. The default value is false, indicating that the first \(window-1\) elements windows return NULL. If set to true, elements in the first \(window-1\) windows are calculated based on the formula given in the details.

## Details {#details}

Calculate the Exponential Moving Average \(ema\) for *X* in a count-based sliding window of the given length.

The calculation formula is as follows:

warmup=false:

-   ![](../../images/ema_k.png)

-   warmup=true:

    ![](../../images/ema_ktrue.png)

    where *EMAk* is the k-th exponential moving average, *n* is the length of sliding window, *Xk* is the k-th element of the vector *X*.


## Examples {#examples}

```
x=12.1 12.2 12.6 12.8 11.9 11.6 11.2
ema(x,3);
// output: [,,12.3,12.55,12.225,11.9125,11.55625]

x=matrix(12.1 12.2 12.6 12.8 11.9 11.6 11.2, 14 15 18 19 21 12 10)
ema(x,3);
```

|\#0|\#1|
|---|---|
|||
|||
|12.30|15.666667|
|12.55|17.333333|
|12.225|19.166667|
|11.9125|15.583333|
|11.55625|12.791667|

Related functions: [gema](../g/gema.md), [wilder](../w/wilder.md), [dema](../d/dema.md), [tema](../t/tema.md)

