# eig {#eig}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`eig(A)`

## Arguments {#arguments}

**A** is a real symmetric matrix or a Hermitian matrix.

## Details {#details}

Calculate the eigenvalues and eigenvectors of *A*.

The result of `eig` is the same as the result of `numpy.linalg.eigh`.

**Return value**: a dictionary

## Examples {#examples}

```
A = 1 1 2 7 9 3 5 7 0 $ 3:3;
eig(A);
/* output
vectors->
#0        #1       #2
--------- -------- ---------
0.839752  0.169451 -0.515852
-0.301349 0.935753 -0.18318
0.45167   0.309277 0.836864

values->[1.716868,10.17262,-1.889488]
*/
```

For the eigenvalue of 1.716868, the corresponding eigenvector is:

```
eig(A).vectors[0];
// output: [0.839752,-0.301349,0.45167]
```

