# dumpHeapSample {#dumpHeapSample}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`dumpHeapSample(filename)`

## Details {#details}

This function generates a snapshot of the current heap memory. It records the current memory usage, including allocated memory blocks, their sizes, and states. Only administrators can execute this function.

## Arguments {#arguments}

**filename** is a string representing the path for the heap memory snapshot file.

## Examples {#examples}

Recommended workflow for memory usage analysis:

1.  Enable heap memory sampling: This can be done by setting the environment variable TCMALLOC\_SAMPLE\_PARAMETER to a value between 1 and 524288 \(recommended: 524288\) before starting DolphinDB; or by dynamically enabling it using `startHeapSample`.
2.  Execute `dumpHeapSample` before and after operations that may cause memory leaks, saving to two different files. Compare these files to confirm memory allocation and usage related to the operation.
3.  Disable heap memory sampling.

``` {#codeblock_fwj_vzb_bdc}
startHeapSample(524288)
​
dumpHeapSample("/DolphinDB/Data/heap1")
dumpHeapSample("/DolphinDB/Data/heap2")
​
stopHeapSample()
```

Related functions: [startHeapSample](../s/startHeapSample.md), [stopHeapSample](../s/stopHeapSample.md)

