# dropTable {#droptable}

## Syntax {#syntax}

`dropTable(dbHandle, tableName)`

## Arguments {#arguments}

**dnHandle** is a DolphinDB database handle.

**tableName** is a string indicating a table name.

## Details {#details}

Delete the specified table on disk. It can only be executed on a data node or compute node.

## Examples {#examples}

```
n=1000000
ID=rand(10, n)
x=rand(1.0, n)
t=table(ID, x)
db=database("dfs://rangedb", RANGE,  0 5 10)
pt = db.createPartitionedTable(t, `pt, `ID)
pt.append!(t)

dropTable(db,`pt);
```

