# dropStreamTable {#dropstreamtable}

## Syntax {#syntax}

`dropStreamTable(tableName, [force=false])`

## Arguments {#arguments}

**tableName** is a string indicating a stream table name.

**force** \(optional\) is a Boolean scalar indicating whether to force the deletion of the stream table named *tableName* from the disk if it is not available in memory. The default value is false.

## Details {#details}

Delete a stream table. If the table has been persisted to disk, the persisted data on disk will be deleted as well.

To delete a high-availability stream table, we can execute the command on any data/compute node in the Raft group. The high-availability stream table with the same name on other data nodes will be deleted as well.

If the table has been persisted to disk but not yet loaded into memory, setting the parameter *force* to true can delete the table directly from disk. Note that it can only be executed by an administrator.

## Examples {#examples}

Delete stream table:

```
colNames = `timestamp`sym`qty`price
colTypes = [TIMESTAMP,SYMBOL,INT,DOUBLE]
t=streamTable(1:0,colNames,colTypes)
enableTableShareAndPersistence(t,`trades);

dropStreamTable(`trades);
```

Delete a stream table that has been persisted to disk but not yet loaded into memory.

``` {#codeblock_y1t_js3_b1c}
colNames = `timestamp`sym`qty`price
colTypes = [TIMESTAMP,SYMBOL,INT,DOUBLE]
t=streamTable(1:0,colNames,colTypes)
enableTableShareAndPersistence(t,`trades);

//delete an in-memory stream table
undef(`trades,SHARED)

//failed to delete a persisted stream table
dropStreamTable(`trades)
//dropStreamTable("trades") => Can't find stream table trades

//set force to true
dropStreamTable(tableName=`trades,force=true)
```

Delete high-availability stream table:

```
colNames = `timestamp`sym`qty`price
colTypes = [TIMESTAMP,SYMBOL,INT,DOUBLE]
t=table(1:0,colNames,colTypes)
haStreamTable(11,t,`trades,100000);

dropStreamTable(`trades);
```

