# dropStreamEngine {#dropstreamengine}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`dropStreamEngine(name)`

Alias: `dropAggregator`

## Arguments {#arguments}

**name** is a string indicating the name of a created stream engine. You can obtain all created engines with function [getStreamEngineStat](../g/getStreamEngineStat.md).

## Details {#details}

Release the definition of a stream engine from the memory.

## Examples {#examples}

```
share streamTable(1000:0, `time`sym`qty, [TIMESTAMP, SYMBOL, INT]) as trades
outputTable = table(10000:0, `time`sym`sumQty, [TIMESTAMP, SYMBOL, INT])
tradesEngine = createTimeSeriesEngine(name="StreamEngineDemo", windowSize=3, step=3, metrics=<[sum(qty)]>, dummyTable=trades, outputTable=outputTable, timeColumn=`time, useSystemTime=false, keyColumn=`sym, garbageSize=50)
subscribeTable(tableName="trades", actionName="tradesEngine", offset=0, handler=append!{tradesEngine}, msgAsTable=true)
```

```
def writeData(n){
    timev = 2018.10.08T01:01:01.001 + timestamp(1..n)
    symv =take(`A`B, n)
    qtyv = take(1, n)
    insert into trades values(timev, symv, qtyv)
}

writeData(6);
```

```
// output: select * from outputTable;
```

|time|sym|sumQty|
|----|---|------|
|2018.10.08T01:01:01.003|A|1|
|2018.10.08T01:01:01.006|A|1|
|2018.10.08T01:01:01.006|B|2|

```
dropStreamEngine("StreamEngineDemo");
```

