# dropFunctionView {#dropfunctionview}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`dropFunctionView(name, [isNamespace=false])`

## Arguments {#arguments}

**name** is a STRING scalar indicating a user-defined function or a namespace.

**isNamespace** is a Boolean value specifying whether *name* is a namespace.

## Details {#details}

Delete a function view or all function views under a namespace.

It can only be executed by administrators or users with VIEW\_OWNER permission.

``` {#codeblock_b1k_klx_3dc}
getFunctionViews()
name      body                           
--------- ------------------
f1        def f1(){return 1}
test::f1 def f1(){return 2}
test::f2 def f2(){return 3}

// Drop f1
dropFunctionView(`f1)
// Drop test::f1
dropFunctionView("test::f1")
// Drop all function views under test
dropFunctionView("test",true)
```

