# dropDistributedInMemoryTable {#dropdistributedinmemorytable}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`dropDistributedInMemoryTable(tableName)`

## Arguments {#arguments}

**tableName** is a STRING scalar indicating column names of a distributed in-memory table.

## Details {#details}

Delete the specified distributed in-memory table. This function can only be executed on a data node or compute node.

## Examples {#examples}

```
pt = createDistributedInMemoryTable(`dt, `time`id`value, `DATETIME`INT`LONG, HASH, [INT, 2],`id)
time = take(2021.08.20 00:00:00..2021.08.30 00:00:00, 40);
id = 0..39;
value = rand(100, 40);
tmp = table(time, id, value);

pt = loadDistributedInMemoryTable(`dt)
pt.append!(tmp);
dropDistributedInMemoryTable(`dt)
```

Related functions: [loadDistributedInMemoryTable](../l/loadDistributedInMemoryTable.md), [createDistributedInMemoryTable](../c/createDistributedInMemoryTable.md)

