# dropColumns! {#dropcolumns}

## Syntax {#syntax}

`dropColumns!(table, colNames)`

Alias: drop!

## Arguments {#arguments}

**table** is a table object. It is an in-memory table or a DFS table \(for OLAP engine only\).

**colNames** is a STRING scalar/vector indicating a column name. If *table* is a DFS table, it must be a scalar.

## Details {#details}

Delete one or multiple columns from a table. Note that deleting a partitioning column from a DFS table is not supported.

## Examples {#examples}

```
t=table(1 2 3 as x, 4 5 6 as y, 7..9 as z, 10..12 as a, 13..15 as b, 16..18 as c);
t;
```

|x|y|z|a|b|c|
|---|---|---|---|---|---|
|1|4|7|10|13|16|
|2|5|8|11|14|17|
|3|6|9|12|15|18|

```
t.dropColumns!(`x);
```

|y|z|a|b|c|
|---|---|---|---|---|
|4|7|10|13|16|
|5|8|11|14|17|
|6|9|12|15|18|

```
dropColumns!(t, `a`b);
```

|y|z|c|
|---|---|---|
|4|7|16|
|5|8|17|
|6|9|18|

