# drop {#drop}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`drop(X, n)`

## Arguments {#arguments}

**X** is a vector/matrix/table.

**n** is an integer.

## Details {#details}

-   If *X* is a vector, delete the first *n* or last *n* \(if *n* is negative\) elements.
-   If *X* is a matrix, delete the first *n* or last *n* \(if *n* is negative\) columns.
-   If *X* is a table, delete the first *n* or last *n* \(if *n* is negative\) rows.

## Examples {#examples}

```
x=1..10;
x.drop(2);
// output: [3,4,5,6,7,8,9,10]
x.drop(-2);
// output: [1,2,3,4,5,6,7,8]

x=1..10$2:5;
x;
```

|\#0|\#1|\#2|\#3|\#4|
|---|---|---|---|---|
|1|3|5|7|9|
|2|4|6|8|10|

```
drop(x,2);
```

|\#0|\#1|\#2|
|---|---|---|
|5|7|9|
|6|8|10|

```
x drop -2;
```

|\#0|\#1|\#2|
|---|---|---|
|1|3|5|
|2|4|6|

```
t=table(1 2 3 4 as x, 11..14 as y);
t;
```

|x|y|
|---|---|
|1|11|
|2|12|
|3|13|
|4|14|

```
t.drop(2);
```

|x|y|
|---|---|
|3|13|
|4|14|

