# dividedDifference {#divideddifference}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`dividedDifference(X, Y, resampleRule, [closed='left'], [origin='start_day'], [outputX=false])`

## Arguments {#arguments}

**X** is a strictly increasing vector of temporal type.

**Y** is a numeric vector of the same length as *X*.

**resampleRule** is a string. See the parameter *rule* of function [resample](../r/resample.md) for the optional values.

**closed** and **origin** are the same as the parameters *closed* and *origin* of function [resample](../r/resample.md).

**outputX** is a Boolean value indicating whether to output the resampled *X*. The default value is false.

## Details {#details}

Resample *X* based on the specified *resampleRule*, *closed* and *origin*. Perform divided difference interpolation on *Y* based on the resampled *X*.

If *outputX* is unspecified, return a vector of *Y* after the interpolation.

If *outputX*=true, return a tuple where the first element is the vector of resampled *X* and the second element is a vector of *Y* after the interpolation.

## Examples {#examples}

```
dividedDifference([2016.02.14 00:00:00, 2016.02.15 00:00:00, 2016.02.16 00:00:00], [1.0, 2.0, 4.0], resampleRule=`60min);

/* output
[1,1.0217,1.0451,1.0703,1.0972,1.1259,1.1562,1.1884,1.2222,1.2578,
1.2951,1.3342,1.375,1.4175,1.4618,1.5078,1.5556,1.605,1.6562,1.7092,
1.7639,1.8203,1.8785,1.9384,2,2.0634,2.1285,2.1953,2.2639,2.3342,
2.4062,2.48,2.5556,2.6328,2.7118,2.7925,2.875,2.9592,3.0451,3.1328,
3.2222,3.3134,3.4062,3.5009,3.5972,3.6953,3.7951,3.8967,4]
*/
```

