# distinct {#distinct}

## Syntax {#syntax}

`distinct(X)`

## Arguments {#arguments}

**X** is a vector or array vector.

## Details {#details}

Return the distinct elements from *X*. Since version 2.00.173.00.4, the order of the returned elements matches the order of their first appearance in the input.

## Examples {#examples}

```
distinct(4 5 5 2 3)
// output: [4,5,2,3]

a = array(INT[], 0, 10).append!([1 2 3,  4 5, 6 7 8, 9 10])
distinct(a)
// output: [1,2,3,4,5,6,7,8,9,10]

t=table(3 1 2 2 3 as x);
select distinct x from t;
```

|distinct\_x|
|-----------|
|3|
|1|
|2|

```
select sort(distinct(x)) as x from t;
```

|x|
|---|
|1|
|2|
|3|

The function `distinct` returns a vector, while the function [set](../s/set.md) returns a set.

```
x=set(4 5 5 2 3)
x
// output: set(3,2,5,4)

x.intersection(set(2 5))
// output: set(2,5)
```

For in-memory or distributed tables, `distinct` can be used with `group by` to return an array vector of unique values for each group.

``` {#codeblock_hwv_dqp_mgc}
dbName = "dfs://testdb"
if(existsDatabase(dbName)){
   dropDatabase(dbName)
}

db=database("dfs://testdb", VALUE, 2012.01.11..2012.01.29)

n=100
t=table(take(2012.01.11..2012.01.29, n) as date, symbol(take("A"+string(21..60), n)) as sym, take(100, n) as val)

pt=db.createPartitionedTable(t, `pt, `date).append!(t)
result=select distinct(date) from pt group by sym
select sym, distinct_date from result where sym=`A21
```

|sym|distinct\_date|
|---|--------------|
|A21|\[2012.01.15,2012.01.13,2012.01.11\]|

