# dict {#dict}

## Syntax {#syntax}

`dict(keyObj, valueObj, [ordered=false])`

or

`dict(keyType, valueType, [ordered=false])`

## Arguments {#arguments}

For the first usage:

**keyObj** is a vector indicating dictionary keys.

**valueObj** is a vector indicating dictionary values.

For the second usage:

**keyType** is the data type of dictionary keys. The following data categories are supported: Integral \(excluding COMPRESSED\), Temporal, Floating and Literal.

**valueType** is the data type of dictionary values. Note that COMPLEX/POINT/DECIMAL is not supported.

**ordered** \(optional\) is a Boolean value. The default value is false, which indicates to create a regular dictionary. True means to create an ordered dictionary. The regular dictionaries do not track the insertion order of the key-value pairs whereas the ordered dictionaries preserve the insertion order of key-value pairs.

## Details {#details}

Return a dictionary object.

## Examples {#examples}

```
x=1 2 3
y=4.5 7.8 4.3
z=dict(x,y);
z;
/* output
3->4.3
1->4.5
2->7.8
*/

z=dict(INT,DOUBLE);
z[5]=7.9;
z;
// output: 5->7.9

z[3]=6;
z;
/* output
3->6
5->7.9
*/

dt=dict([`test], [1]);
dt;
// output: test->1

//create an ordered dictionary
z=dict(x,y,true)
z;
/* ouput
1->4.5
2->7.8
3->4.3
*/

// y is a vector of DECIMAL32 type. Create an ordered dictionary z with y as values.
x=1 3 2
y = decimal32\(1.23 3 3.14, 3\)
z=dict\(x,y,true\);
z;
/\* output
1-&gt;1.230
3-&gt;3.000
2-&gt;3.140
*/
```

To get keys and values of a dictionary:

```
x=1 2 3
y=4.5 7.8 4.3
z=dict(x,y);

z.keys();
// output: [3,1,2]

z.values();
// output: [4.3,4.5,7.8]
```

related system functions: [array](../a/array.md), [matrix](../m/matrix.md), [dictUpdate!](dictUpdate!.md), [syncDict](../s/syncDict.md)

