# demean {#demean}

## Syntax {#section_kfv_ndg_dzb .section}

`demean(X)`

## Arguments {#section_app_qdg_dzb .section}

`X` is a numeric scalar/vector/matrix/table.

## Details {#section_w43_rdg_dzb .section}

Center a dataset \(zero-centering\), and return an object of DOUBLE type with the same dimension as *X*. Null values are ignored in the calculation.

-   If *X* is a vector, calculate X - avg\(X\);

-   If *X* is a matrix, perform calculations by columns;

-   If *X* is a table, perform calculations only for numeric columns.


## Examples {#section_td2_sdg_dzb .section}

``` {#codeblock_tzt_sdg_dzb}
x = 1 NULL 2 3
demean(x)
// output: [-1,,0,1]

v = 1 0 1 1 8 2 -4 0
demean(v)
// output: [-0.125,-1.125,-0.125,-0.125,6.875,0.875,-5.125,-1.125]
```

**Parent topic:**[Functions](../../Functions/category.md)

