# deleteRule {#deleterule}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`deleteRule(engineName, key)`

## Arguments {#arguments}

**engineName**is a string indicating the engine name.

**key**is a STRING or INT scalar indicating the key for the rule set to be deleted.

## Details {#details}

If the specified *key*already exists in the rule engine, delete the corresponding rule set. The default rule set cannot be deleted.

**Return value**: true if successful, otherwise false.

## Examples {#examples}

```python
x = [1, 2, NULL]
y = [ [ < value>1 > ], [ < price<2 >, < price>6 > ], [ < value*price>10 > ] ]
ruleSets = dict(x, y)
names = `sym`value`price`quatity
types = [INT, DOUBLE, DOUBLE, DOUBLE]
dummy = table(10:0, names, types)
outputNames = `sym`value`price`rule
outputTypes = [INT, DOUBLE, DOUBLE, BOOL[]]
outputTable = table(10:0, outputNames, outputTypes)
test = createRuleEngine("ruleEngineTest",ruleSets,dummy ,`sym`value`price, outputTable,  "all",`sym)

test.append!(table(1 as sym, 6 as value, 1 as price, 8 as quatity))
// outputTable: 1	6	1	[true]

// delete the rule set for sym=1 and the default rule set will be applied to sym=1.
deleteRule("ruleEngineTest",1)
test.append!(table(1 as sym, 6 as value, 1 as price, 8 as quatity))
// outputTable: 1	6	1	[false]
```

