# deleteMarketHoliday {#deleteMarketHoliday}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`deleteMarketHoliday(marketName)`

## Arguments {#arguments}

**marketName** is a STRING scalar, indicating the identifier of the trading calendar to delete, e.g., “XNYS“.

## Details {#details}

Delete an existing trading calendar on the current node.

**Note:**

-   This function can only be executed by an administrator.

-   It only takes effect on the current node. In a cluster, `pnodeRun` can be used to call this function on all data/compute nodes.


## Examples {#examples}

``` {#codeblock_gdt_vwp_dfc}
listAllMarkets()
// Output: ["XTSE","XCSE","XLIM","ADDA","XSTO","XIST","AIXK","SSE","XMIL","XFRA","INE","XMEX","XBUD","XICE","XDUB","SHFE","CMES","XOSL","DCE","CCFX","CFFEX","XIDX","BVMF","XBOG","XKAR","XSAU","XBUE","XTKS","XBSE","XMOS"...]

deleteMarketHoliday("XTSE")
"XTSE" in listAllMarkets()
// Output: false
```

**Related function: [addMarketHoliday](../a/addMarketHoliday.md)**

