# defs {#defs}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax_defs}

`defs([X])`

## Arguments {#para_defs}

**X** is a string. It supports wildcard symbols "%" and "?". "%" means 0, 1 or multiple characters and "?" means 1 character.

## Details {#details_defs}

-   If *X* is not specified, return all functions in the system as a table.
-   If *X* is specified, return all functions with names consistent with the pattern of *X*.

## Examples {#emp_defs}

``` {#codeblock_rm5_thn_ryb}
defs();
```

|name|isCommand|userDefined|minParamCount|maxParamCount|syntax|
|----|---------|-----------|-------------|-------------|------|
|!=\_2|0|0|2|2|\(X, Y\)|
|!\_1|0|0|1|1|\(X\)|
|$\_2|0|0|2|2|\(obj, type\)|
|%\_2|0|0|2|2|\(X, Y\)|
|&amp;&amp;\_2|0|0|2|2|\(X, Y\)|
|&amp;\_2|0|0|2|2|\(X, Y\)|
|\*\*\_2|0|0|2|2|\(X, Y\)|
|\*\_2|0|0|2|2|\(X, Y\)|
|+\_2|0|0|2|2|\(X, Y\)|
|-\_1|0|0|1|1|\(X\)|
|...||||||

``` {#codeblock_tm5_thn_ryb}
typestr defs();
// output: IN-MEMORY TABLE;

select * from defs() where name like "bit%";
```

|name|isCommand|userDefined|minParamCount|maxParamCount|syntax|
|----|---------|-----------|-------------|-------------|------|
|bitAnd|0|0|2|2|\(X, Y\)|
|bitNot|0|0|1|1|\(X\)|
|bitOr|0|0|2|2|\(X, Y\)|
|bitXor|0|0|2|2|\(X, Y\)|

``` {#codeblock_vm5_thn_ryb}
defs("bit%");
```

|name|isCommand|userDefined|minParamCount|maxParamCount|syntax|
|----|---------|-----------|-------------|-------------|------|
|bitAnd|0|0|2|2|\(X, Y\)|
|bitNot|0|0|1|1|\(X\)|
|bitOr|0|0|2|2|\(X, Y\)|
|bitXor|0|0|2|2|\(X, Y\)|

``` {#codeblock_xm5_thn_ryb}
defs("%sin");
```

|name|isCommand|userDefined|minParamCount|maxParamCount|syntax|
|----|---------|-----------|-------------|-------------|------|
|asin|0|0|1|1|\(X\)|
|sin|0|0|1|1|\(X\)|

``` {#codeblock_zm5_thn_ryb}
defs("?sin");
```

|name|isCommand|userDefined|minParamCount|maxParamCount|syntax|
|----|---------|-----------|-------------|-------------|------|
|asin|0|0|1|1|\(X\)|

