# decodeShortGenomeSeq {#decodeshortgenomeseq}

## Syntax {#section_fhp_vcg_dzb .section}

`decodeShortGenomeSeq(X)`

Alias: decodeSGS

## Arguments {#section_nl4_wcg_dzb .section}

**X** is an integral scalar/vector.

## Details {#section_fwc_xcg_dzb .section}

Decode the DNA sequences which have been encoded with `encodeShortGenomeSeg`.

**Return Value**: a STRING scalar or vector

## Examples {#section_abf_zcg_dzb .section}

``` {#codeblock_pnw_zcg_dzb}
a=encodeShortGenomeSeq("TCGATCG")
decodeShortGenomeSeq(a)
// output: "TCGATCG"

b=encodeShortGenomeSeq("TCGATCG" "TCGATCGCCC")
decodeShortGenomeSeq(b)
// output: ["TCGATCG","TCGATCGCCC"]
    
// When the input is empty, an empty string is returned.
decodeShortGenomeSeq(int(NULL))
// output: ""
    
// encodeShortGenomeSeq returns NULL as the input exceeds 28 characters after "TCGATCG" is repeated 5 times. As a result, when decoding it, an empty string is returned.
c=encodeShortGenomeSeq(repeat("TCGATCG" "TCGAT", 5))
decodeShortGenomeSeq(c)
// output: [,"TCGATTCGATTCGATTCGATTCGAT"]     
```

Related functions: [encodeShortGenomeSeq](../e/encodeShortGenomeSeq.md), [genShortGenomeSeq](../g/genShortGenomeSeq.md)

**Parent topic:**[Functions](../../Functions/category.md)

