# declareStreamingSQLTable {#declareStreamingSQLTable}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`declareStreamingSQLTable(table)`

## Arguments {#arguments}

**table** A table object. Currently supports a shared table, including the in-memory table, keyed table and indexed table.

## Details {#details}

Declare a specified table as the input table of streaming SQL. Only the declared table can be registered for streaming SQL query via `registerStreamingSQL`. This function does not affect the use of the table in regular SQL queries or other features.

**Return value**: None.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
t=table(1..10 as id,rand(100,10) as val)
share t as st
declareStreamingSQLTable(st)
registerStreamingSQL("select avg(val) from st")
```

**Related functions:** [listStreamingSQLTables](../l/listStreamingSQLTables.md), [registerStreamingSQL](../r/registerStreamingSQL.md), [revokeStreamingSQLTable](../r/revokeStreamingSQLTable.md)

