# decimal128 {#decimal128}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`decimal128(X, scale)`

## Arguments {#arguments}

**X** is a scalar/vector of Integral, Floating, or STRING type.

**scale** is an integer in \[0,38\] that determines the number of digits to the right of the decimal point.

## Details {#details}

Convert the input values into DECIMAL128.

## Examples {#examples}

```
a=decimal128(142, 2)
a
// output: 142.00

b=decimal128(1\7, 6)
b
// output: 0.142857

a+b
// output: 142.142857

a*b
// output: 20.28569400

decimal128("3.1415926535", 4)
// output: 3.1416

// All elements of a DECIMAL vector must be of the same type and scale
d1=[1.23$DECIMAL128(4), 3$DECIMAL128(4), 3.14$DECIMAL128(4)];
// output: [1.2300,3.0000,3.1400]
typestr(d1)
// output: FAST DECIMAL128 VECTOR

// If the elements are of different scales, a tuple is created
d2=[1.23$DECIMAL128(4), 3$DECIMAL128(4), 3.14$DECIMAL128(3)];
// output: (1.2300,3.0000,3.140)
typestr(d2)
// output: ANY VECTOR
```

