# datetime {#datetime}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`datetime(X)`

## Arguments {#arguments}

**X** is a temporal scalar/vector, or an integer.

## Details {#details}

Convert *X* into DATETIME type. Since version 2.00.12, converting MONTH into DATETIME is allowed.

**Note:** The range for data of DATETIME type is \[1901.12.13T20:45:53, 2038.01.19T03:14:07\].

## Examples {#examples}

```
datetime(2009.11.10);
// output: 2009.11.10T00:00:00

typestr datetime(2009.11.10);
// output: DATETIME

datetime(now());
// output: 2016.03.02T20:51:10

datetime(2012.01M)
// output: 2012.01.01T00:00:00
```

Related functions: [date](date.md), [second](../s/second.md), [minute](../m/minute.md), [month](../m/month.md), [hour](../h/hour.md), [year](../y/year.md)

