# DStream::haKeyedSink {#DStream_haKeyedSink}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`DStream::haKeyedSink(name, keyColumn, raftGroup, cacheLimit, [retentionMinutes=1440])`

## Arguments {#arguments}

**name** A string specifying the name of the target stream table.

**keyColumn** A string scalar or vector specifying the primary key column\(s\).

**raftGroup** can be either an integer greater than 1 or a string.

-   Integer: represents the raft group ID.
-   String: represents a raft group alias, which must be preconfigured via *streamingRaftGroupAliases*.

**cacheLimit** is an integer representing the maximum number of rows of the high-availability stream table to be kept in memory. If *cacheLimit*&gt;1000, it is automatically adjusted to 1000.

**retentionMinutes** \(optional\) is an integer indicating for how long \(in terms of minutes\) a log file larger than 1GB will be kept after last update. The default value is 1440, which means the log file only keeps data in the past 24 hours.

## Details {#details}

Outputs stream data to a high-availability keyed stream table.

For more information on HA stream tables, refer to the [haStreamTable](../h/haStreamTable.md) documentation.

**Return value**: A DStream object.

