# DStream::haKeyedBuffer {#DStream_haKeyedBuffer}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`DStream::haKeyedBuffer(name, keyColumn, raftGroup, cacheLimit, [retentionMinutes=1440])`

## Arguments {#arguments}

**name** is a string representing the name of the Orca stream table. You can provide either the fully qualified name \(FQN\), such as "trading.orca\_table.factors", or just the table name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

**keyColumn** A string scalar or vector specifying the primary key column\(s\).

**raftGroup** can be either an integer greater than 1 or a string.

-   Integer: represents the raft group ID.
-   String: represents a raft group alias, which must be preconfigured via *streamingRaftGroupAliases*.

**cacheLimit** is an integer representing the maximum number of rows of the high-availability stream table to be kept in memory. If *cacheLimit*&gt;1000, it is automatically adjusted to 1000.

**retentionMinutes** \(optional\) is an integer indicating for how long \(in terms of minutes\) a log file larger than 1GB will be kept after last update. The default value is 1440, which means the log file only keeps data in the past 24 hours.

## Details {#details}

Creates a high-availability keyed stream table to store intermediate results in stream processing.

For more information on table persistence, refer to the [haStreamTable](../h/haStreamTable.md) documentation.

**Return value**: A DStream object.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
if (!existsCatalog("orca")) {
	createCatalog("orca")
}
go
use catalog orca

g = createStreamGraph("indicators")

g.source("trade", `time`symbol`price`volume, [DATETIME,SYMBOL,DOUBLE,LONG])
    .timeSeriesEngine(windowSize=60, step=60, metrics=[<first(price) as open>, <max(price) as high>, <min(price) as low>, <last(price) as close>, <sum(volume) as volume>], timeColumn=`time, keyColumn=`symbol)
    .haKeyedBuffer(name="ha_keyedTable", keyColumn=`symbol, raftGroup=3, cacheLimit=5000)
```

