# DStream::fork {#DStream_fork}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`DStream::fork(count)`

## Arguments {#arguments}

**count** An integer specifying the number of branches.

## Details {#details}

Forks the stream data into multiple downstream branches by broadcasting the data to each. Each resulting DStream can be processed independently, supporting parallel or divergent processing logic.

**Return value**: A list of DStream instances.

## Examples {#examples}

Forks the stream data for downstream 1-minute and 5-minute factor calculations:

``` {#codeblock_zq1_tms_c2c}
use catalog test

g = createStreamGraph("indicators")
sourceStreams = g.source("trade", 1024:0, `symbol`datetime`price`volume, [SYMBOL, TIMESTAMP,DOUBLE, INT])
    .fork(2)
stream_1min = sourceStreams[0]
    .timeSeriesEngine(60*1000, 60*1000, <[first(price),max(price),min(price),last(price),sum(volume)]>, "datetime", false, "symbol")
    .reactiveStateEngine(<[datetime, first_price, max_price, min_price, last_price, sum_volume, mmax(max_price, 5), mavg(sum_volume, 5)]>, `symbol)
    .sink("output_1min")
stream_5min = sourceStreams[1]
    .timeSeriesEngine(5*60*1000, 5*60*1000, <[first(price),max(price),min(price),last(price),sum(volume)]>, "datetime", false, "symbol")
    .reactiveStateEngine(<[datetime, first_price, max_price, min_price, last_price, sum_volume, mmax(max_price, 5), mavg(sum_volume, 5)]>, `symbol)
    .sink("output_5min")
g.submit()
```

