# Function References {#function_references}

Reference for all built-in functions

-   **[Categories](../Functions/funcs_by_topics.md)**  

-   **[Functions](../Functions/category.md)**  

-   **[Python-DolphinDB Equivalents](../Functions/py_func_mappings.md)**  


## Notations {#notations}

For unary functions, we use X as the argument. For binary functions, we use X and Y as the first and second argument, respectively. Without clarification, X/Y indicates an object including scalar, vector, matrix, dictionary and table. We have functions such as [take](t/take.md), [rand](r/rand.md), [norm](n/norm.md) that require a scalar to be one of the arguments. For these cases, we use lower case letters such as "a", "b", etc. Contents within \[\] are optional.

**Unary function syntax:**

\(1\) `<function>(X)`

// standard function calling

\(2\) `<function> X`

// parenthesis around X are ignored when putting a function name in front of parameter X; not good for nested function calling

\(3\) `X.<function>()`

// parenthesis around X may be ignored when X is an object; it is more suited for nested function calling

**Binary function syntax:**

\(1\) `<function>(X, Y)`

// standard function calling

\(2\) `X <function> Y`

// put the function name between two parameters; not good for nested function calling

\(3\) `X.<function> (Y)`

// parenthesis around X may be ignored when X is an object; it is more suited for nested function calling

Calling a function by the object-oriented style can be applied to both constants and variables.

For brevity, we will only introduce the first form `<function>(X)` or `<function>(X, Y)` in the syntax section for all unary and binary functions of this chapter.

## Examples {#examples}

```
// 3 ways to call function log
log(10);
// output: 2.302585
log 10;
// output: 2.302585
(10).log();
// output: 2.302585
// a pair of parenthesis is mandatory here in order to treat the constant 10 as an object

x = 5 3 1 10;
log(x);
// output: [1.609438,1.098612,0,2.302585]
log x;
// output: [1.609438,1.098612,0,2.302585]
x.log();
// output: [1.609438,1.098612,0,2.302585]
// a pair of parenthesis are ignored here because x is an vector object
(5 3 1 10).log()
// output: [1.609438,1.098612,0,2.302585]
// a pair of parenthesis are mandatory here in order to treat constant vector 5 2 1 10 as an vector object

sin(add(log(5),7));
// output: 0.727959
```

## Performance Tip {#performance-tip}

The two arguments of most binary operators/functions don't need to be the same data type. The system tries its best to do the conversion. However, it is not recommended to use different data types because it causes performance loss when a significant amount of data type conversion is involved.

