# cumvarp {#cumvarp}

## Syntax {#syntax}

`cumvarp(X)`

Please see [Cumulative Window Functions](../Themes/cumFunctions.md) for the parameter description and windowing logic.

## Details {#details}

Cumulatively calculate the population variance of *X*.

## Examples {#examples}

```
cumvarp(1 2 3 NULL 4);
// output: [ , 0.25, 0.666666666666667, 0.666666666666667, 1.25]
```

```
m=matrix(1.1 3 5.0 7.5 9.2, 1 4.3 7.1 10.6 13.5);
m;
```

|col1|col2|
|----|----|
|1.1|1|
|3|4.3|
|5|7.1|
|7.5|10.6|
|9.2|13.5|

```
cumvarp(m);
```

|col1|col2|
|----|----|
|0|0|
|0.9025|2.7225|
|2.5356|6.2156|
|5.6425|12.5025|
|8.5944|19.612|

Related function: [varp](../v/varp.md)

