# cumvarTopN {#cumvartopn}

## Syntax {#syntax}

`cumvarTopN(X, S, top, [ascending=true], [tiesMethod='latest'])`

Please see [Cumulative Moving TopN Functions](../Themes/cumTopN.md) for the parameters and windowing logic.

## Details {#details}

The function stably sorts *X* by *S* in the order specified by *ascending*, then calculates the unbiased sample variance of the first *top* elements in a cumulative window.

**Return value**: DOUBLE type.

## Examples {#examples}

```
X=1 2 3 10 100 4 3
S = 0.3 0.5 0.1 0.1 0.5 0.2 0.4
cumvarTopN(X, S, 6, 4)
// output: [,0.5,1,16.6666,1855.7,1546,1538.9666]

X = matrix(1..10, 11..20)
S = matrix(2022.01.01 2022.02.03 2022.01.23 NULL 2021.12.29 2022.01.20 2022.01.23 2022.01.22 2022.01.24 2022.01.24, NULL 2022.02.03 2022.01.23 2022.04.06 NULL 2022.02.03 2022.02.03 2022.02.05 2022.02.08 2022.02.03)
cumvarTopN(X, S, 6, 4)
```

|\#0|\#1|
|---|---|
|||
|0.5||
|1|0.5|
|1|1|
|2.9167|1|
|4.3|2.9167|
|5.6|4.3|
|6.8|5.6|
|6.8|7.7667|
|6.8|9.2|

```
id=rand(10,10)
price=rand(100,10)
t=table(id, price)
select cumvarTopN(price, id, 6, 4) as result from t
```

|result|
|------|
||
|800|
|808.3333|
|730.25|
|825.2|
|903.3667|
|747.3667|
|856.7|
|887.4667|
|994.9667|

