# cumsumTopN {#cumsumtopn}

## Syntax {#syntax}

`cumsumTopN(X, S, top, [ascending=true], [tiesMethod='latest'])`

Please see [Cumulative Moving TopN Functions](../Themes/cumTopN.md) for the parameters and windowing logic.

## Details {#details}

The function stably sorts *X* by *S* in the order specified by *ascending*, then sums up the first *top* elements in a cumulative window.

**Return value**: LONG or DOUBLE type.

## Examples {#examples}

```
X=1 2 3 10 100 4 3
S = 0.3 0.5 0.1 0.1 0.5 0.2 0.4
cumsumTopN(X, S, 6)
// output: [1,3,6,16,116,120,121]

X = matrix(1..10, 11..20)
S = matrix(2022.01.01 2022.02.03 2022.01.23 NULL 2021.12.29 2022.01.20 2022.01.23 2022.01.22 2022.01.24 2022.01.24, NULL 2022.02.03 2022.01.23 2022.04.06 NULL 2022.02.03 2022.02.03 2022.02.05 2022.02.08 2022.02.03)
cumsumTopN(X, S, 6)
```

|\#0|\#1|
|---|---|
|1||
|3|12|
|6|25|
|6|39|
|11|39|
|17|55|
|24|72|
|30|90|
|30|95|
|30|96|

```
id=rand(10,10)
price=rand(100,10)
t=table(id, price)
select cumsumTopN(price, id, 6) as result from t
```

|result|
|------|
|32|
|130|
|145|
|223|
|283|
|292|
|344|
|364|
|406|
|333|

