# cumstdpTopN {#cumstdptopn}

## Syntax {#syntax}

`cumstdpTopN(X, S, top, [ascending=true], [tiesMethod='latest'])`

Please see [Cumulative Moving TopN Functions](../Themes/cumTopN.md) for the parameters and windowing logic.

## Details {#details}

The function stably sorts *X* by *S* in the order specified by *ascending*, then calculates the population standard deviation of the first *top* elements in a cumulative window.

**Return value**: DOUBLE type.

## Examples {#examples}

```
X=1 2 3 10 100 4 3
S = 0.3 0.5 0.1 0.1 0.5 0.2 0.4
cumstdpTopN(X, S, 6, 4)
// output: [0,0.5,0.8164,3.5355,38.5299,35.8933,35.8116]

X = matrix(1..10, 11..20)
S = matrix(2022.01.01 2022.02.03 2022.01.23 NULL 2021.12.29 2022.01.20 2022.01.23 2022.01.22 2022.01.24 2022.01.24, NULL 2022.02.03 2022.01.23 2022.04.06 NULL 2022.02.03 2022.02.03 2022.02.05 2022.02.08 2022.02.03)
cumstdpTopN(X, S, 6, 4)
```

|\#1|\#2|
|---|---|
|0||
|0.5|0|
|0.8165|0.5|
|0.8165|0.8165|
|1.479|0.8165|
|1.8547|1.479|
|2.1602|1.8547|
|2.3805|2.1602|
|2.3805|2.5441|
|2.3805|2.7689|

```
id=rand(10,10)
price=rand(100,10)
t=table(id, price)
select cumstdpTopN(price, id, 6, 4) as result from t
```

|result|
|------|
|0|
|28.5|
|26.8701|
|24.8294|
|22.2657|
|29.4543|
|29.4543|
|30.8081|
|25.5435|
|25.5435|

