# cumstdp {#cumstdp}

## Syntax {#syntax}

`cumstdp(X)`

Please see [Cumulative Window Functions](../Themes/cumFunctions.md) for the parameter description and windowing logic.

## Details {#details}

Cumulatively calculate the population standard deviation of *X*.

## Examples {#examples}

```
cumstdp(1 2 4 NULL 8);
// output: [0, 0.5, 1.247219128924647, 1.247219128924647, 2.680951323690902]
```

```
m=matrix(0.15 0.08 0.03 -0.14 -0.09, 0.2 -0.12 -0.16 0.08 0.16);
m;
```

|\#0|\#1|
|---|---|
|0.15|0.2|
|0.08|-0.12|
|0.03|-0.16|
|-0.14|0.08|
|-0.09|0.16|

```
cumstdp(m);
```

|col1|col2|
|----|----|
|0|0|
|0.035|0.16|
|0.0492|0.1611|
|0.107|0.147|
|0.1071|0.1462|

Related function: [stdp](../s/stdp.md)

