# cumrank {#cumrank}

## Syntax {#syntax}

`cumrank(X, [ascending=true], [ignoreNA=true], [tiesMethod='min'], [percent=false])`

Please see [Cumulative Window Functions](../Themes/cumFunctions.md) for the parameter description and windowing logic.

## Arguments {#arguments}

**X** is a vector/ matrix.

**ascending** \(optional\) is a Boolean value indicating whether to sort in ascending order. It is an optional parameter and the default value is true.

**ignoreNA** \(optional\) is a Boolean value indicating whether null values are ignored in ranking. True means ignoring the null value, and false means the null values participate in the calculation. The default value is true. If null values participate in the ranking, they are ranked the lowest.

**tiesMethod** \(optional\) is a string indicating how to rank the group of records with the same value \(i.e., ties\):

-   'min': lowest rank of the group

-   'max': highest rank of the group

-   'average': average rank of the group


**percent** \(optional\) is a Boolean value, indicating whether to display the returned rankings in percentile form. The default value is false.

## Details {#details}

If *X* is a vector, for each element in *X*, return the position ranking from the first element to the current element. The result is of the same length as *X*. If *ignoreNA* = true, null values return NULL.

If *X* is a matrix, conduct the aforementioned calculation within each column of *X*. The result is a matrix with the same shape as *X*.

## Examples {#examples}

```
cumrank(1 3 2 3 4);
// output: [0,1,1,2,4]

cumrank(1 3 2 2 4 NULL, , true);
// output: [0,1,1,1,4,]

cumrank(1 3 2 2 4 NULL, , false);
// output: [0,1,1,1,4,0]

cumrank(1 3 2 2 4 NULL, , false, 'max');
// output: [0,1,1,2,4,0]

m=matrix(1 4 2 3 4, 4 NULL 6 1 2);
m;
```

|\#0|\#1|
|---|---|
|1|4|
|4||
|2|6|
|3|1|
|4|2|

```
cumrank(m);
```

|\#0|\#1|
|---|---|
|0|0|
|1||
|1|1|
|2|0|
|3|1|

Related function: [rank](../r/rank.md)

