# cumlastNot {#cumlastnot}

## Syntax {#syntax}

`cumlastNot(X, [k])`

## Arguments {#arguments}

**k** is a scalar.

Please see [Cumulative Window Functions](../Themes/cumFunctions.md) for the parameter description and windowing logic.

## Details {#details}

If *X* is a vector:

-   If *k* is unspecified, return the last non-null element in *X*;
-   If *k* is specified, return the last element that is not *k*.

If *X* is a matrix, conduct the aforementioned calculation within each column of *X*. The result is a matrix with the same shape as *X*.

## Examples {#examples}

```
x=[NULL,1,2,6,NULL,3,4,NULL]
cumlastNot(x);
// output: [,1,2,6,6,3,4,4]

cumlastNot(x, 4)
// output: [,1,2,6,6,3,3,3]

m=matrix(1 2 3 NULL 4, NULL NULL 8 8 9);
m;
```

|\#0|\#1|
|---|---|
|1||
|2||
|3|8|
||8|
|4|9|

```
cumlastNot(m);
```

|\#0|\#1|
|---|---|
|1||
|2||
|3|8|
|3|8|
|4|9|

Related function: [lastNot](../l/lastNot.md)

