# cumkurtosisTopN {#cumkurtosistopn}

## Syntax {#syntax}

`cumkurtosisTopN(X, S, top, [biased=true], [ascending=true], [tiesMethod='latest'])`

## Arguments {#arguments}

**biased** \(optional\) is a Boolean value indicating whether the result is biased. The default value is true, meaning the bias is not corrected.

Please see [Cumulative Moving TopN Functions](../Themes/cumTopN.md) for the parameters and windowing logic.

## Details {#details}

The function stably sorts *X* by *S* in the order specified by *ascending*, then calculates the moving kurtosis of the first *top* elements in a cumulative window.

**Return value**: DOUBLE type.

## Examples {#examples}

```
X=1 2 3 10 100 4 3
S = 0.3 0.5 0.1 0.1 0.5 0.2 0.4
cumkurtosisTopN(X, S, 6, 4)
// output: [,,1.5,2.2304,3.2152,4.1525,4.1554]

X = matrix(1..10, 11..20)
S = matrix(2022.01.01 2022.02.03 2022.01.23 NULL 2021.12.29 2022.01.20 2022.01.23 2022.01.22 2022.01.24 2022.01.24, NULL 2022.02.03 2022.01.23 2022.04.06 NULL 2022.02.03 2022.02.03 2022.02.05 2022.02.08 2022.02.03)
cumkurtosisTopN(X, S, 6, 4)
```

|\#0|\#1|
|---|---|
|||
|||
|1.5||
|1.5|1.5|
|1.8457|1.5|
|1.5092|1.8457|
|1.5|1.5092|
|1.9204|1.5|
|1.9204|1.6107|
|1.9204|1.7297|

```
id=rand(10,10)
price=rand(100,10)
t=table(id, price)
select cumkurtosisTopN(price, id, 6, 4) as result from t
```

|result|
|------|
||
||
|1.5|
|1.4036|
|1.537|
|1.8185|
|1.8838|
|2.0968|
|2.6695|
|2.6695|

